/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.predicate;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.List;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemonParser;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class PokemonPredicate
implements MessagePredicate<PlayerBattleParticipant> {
    protected boolean containsPokemon(List<Pokemon> party, ShowdownPokemon required) {
        for (Pokemon p : party) {
            if (!this.isSpeciesEqual(p, required) || !this.isFormEqual(p, required)) continue;
            return true;
        }
        return false;
    }

    private boolean isSpeciesEqual(Pokemon party, ShowdownPokemon required) {
        try {
            class_2960 p = party.getSpecies().getResourceIdentifier();
            class_2960 r = ShowdownPokemonParser.toSpeciesResourceIdentifier(required.species);
            return p.equals((Object)r);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean isFormEqual(Pokemon party, ShowdownPokemon required) {
        if (required.form == null) {
            return true;
        }
        return party.getForm().getName().equals(required.form);
    }

    protected class_2561 toPokemonDescriptor(ShowdownPokemon pokemon) {
        try {
            boolean isFormExist;
            class_2960 identifier = ShowdownPokemonParser.toSpeciesResourceIdentifier(pokemon.species);
            Species species = PokemonSpecies.INSTANCE.getByIdentifier(identifier);
            boolean bl = isFormExist = pokemon.form != null;
            if (isFormExist) {
                return species.getTranslatedName().method_27693(" ").method_27693(pokemon.form);
            }
            return species.getTranslatedName();
        }
        catch (NullPointerException e) {
            class_2960 identifier = ShowdownPokemonParser.toSpeciesResourceIdentifier(pokemon.species);
            CobblemonTrainerBattle.LOGGER.error("Unknown Pokemon species: {}", (Object)identifier);
            throw new IllegalStateException(e);
        }
    }
}

